/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  flash.h
//  Functions to write and read the flash memory (eeprom replacement)
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef FLASH_H
#define FLASH_H


// global variable for setting main parameters
//extern volatile signed int ref_voltage;

extern volatile unsigned int backlight;
extern volatile unsigned int charge_enabled;
extern volatile unsigned int battery_type;
extern volatile unsigned int master_slave;
extern volatile unsigned int trickle_voltage;
extern volatile unsigned int float_voltage;
extern volatile unsigned int minimum_voltage;
extern volatile unsigned int current_limit;
extern volatile unsigned int power_limit;
extern volatile unsigned int minimum_current_trickle;
extern volatile unsigned int mains_uvlo;
extern volatile unsigned int mains_ovv;
extern volatile unsigned int temperature_coefficient;
extern volatile unsigned int overtemperature_protection;

// global variables for setting the switching frequency
//extern volatile unsigned int threshold0_fswitch;


// Write unsigned integer to flash
// Length is the number of integers to be written.
// In one segment maximum 32 16-bit integers can be written.
extern void flash_write(unsigned int* data, unsigned int length);

// Read unsigned integer from flash.
// Length is the number of integers to be read.
extern void flash_read(unsigned int* data, unsigned int length);

// Read the stored values from flash and check if they are in range.
extern void flash_restore_configuration(void);

// Save the values of the output voltage and switching frequency to flash.
extern void flash_save_configuration(void);


#endif /*FLASH_H*/
